/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.google.common.collect.Maps;
import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.config.IllagerAdditionsConfig;
import com.pikachu.mod.illager_more.entities.NewSamuraiEntity;
import com.pikachu.mod.illager_more.entities.effects.AttackEffects;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class ShogunEntity
extends NewSamuraiEntity {
    protected Vec3 rapidAssaultDeltaMovement;
    protected int targetTimer;
    public Map<LivingEntity, Integer> hitMobMap = new HashMap<LivingEntity, Integer>();
    protected List<Entity> entityList = new ArrayList<Entity>();
    public boolean isLeader;
    public static final EntityDataAccessor<Boolean> IS_ASSAULT = SynchedEntityData.m_135353_(ShogunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DODGING_FAST = SynchedEntityData.m_135353_(ShogunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BUFFED = SynchedEntityData.m_135353_(ShogunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ShogunEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.maxParryTimes = 6;
        this.maxParryChanges = 1;
        this.f_21364_ = 75;
        this.targetTimer = 0;
        this.aiStrength = 3;
        this.isLeader = false;
    }

    @Override
    protected void populateDefaultEquipmentSlots(@Nonnull DifficultyInstance p_180481_1_) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
        }
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.SHOGUN_HELMET.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SHOGUN_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_LEGGINGS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_BOOTS.get()));
        this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
    }

    @Override
    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        Item itemstack = (Item)ModItems.POWERFUL_KATANA.get();
        this.m_19983_(new ItemStack((ItemLike)itemstack));
        for (int i = this.m_217043_().m_188503_(4); i < 8; ++i) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42616_));
        }
        super.m_7472_(p_21385_, p_21386_, p_21387_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ASSAULT, (Object)false);
        this.f_19804_.m_135372_(IS_DODGING_FAST, (Object)false);
    }

    @Override
    public boolean m_6469_(DamageSource type, float damages) {
        Entity entity = type.m_7640_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (this.getReboundedProjectiles().equals(projectile)) {
                projectile.m_146870_();
                return false;
            }
        }
        return super.m_6469_(type, damages);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22282_, (double)1.45f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 3.75);
    }

    @Override
    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
        boolean applyEnchant;
        if (this.m_37885_() == null) {
            return;
        }
        if (this.m_37885_().m_37771_() != this.m_37885_().m_37724_(Difficulty.HARD)) {
            this.m_146870_();
        }
        ItemStack katana = new ItemStack((ItemLike)ModItems.KATANA.get());
        Raid raid = this.m_37885_();
        int enchantmentLevel = 3;
        if (raid != null && p_213660_1_ > raid.m_37724_(Difficulty.NORMAL)) {
            enchantmentLevel = 4;
        }
        if (raid == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, katana);
            return;
        }
        boolean bl = applyEnchant = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (applyEnchant) {
            HashMap enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.f_44977_, enchantmentLevel);
            EnchantmentHelper.m_44865_((Map)enchantmentIntegerMap, (ItemStack)katana);
        }
        this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
        this.m_8061_(EquipmentSlot.MAINHAND, katana);
    }

    protected void m_213946_(RandomSource p_217063_, DifficultyInstance p_217064_) {
    }

    public void m_8119_() {
        if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
            this.isLeader = true;
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.SHOGUN_HELMET.get()));
        }
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null) {
            ++this.targetTimer;
            if (this.targetTimer % 60 == 0) {
                this.hitMobMap.putIfAbsent(this.m_5448_(), 1);
                this.hitMobMap.replace(this.m_5448_(), this.hitMobMap.get(this.m_5448_()), this.hitMobMap.get(this.m_5448_()) + 1 + this.m_217043_().m_188503_(2));
            }
        } else {
            this.targetTimer = 0;
        }
        if (((Boolean)this.f_19804_.m_135370_(IS_ASSAULT)).booleanValue()) {
            return;
        }
        if (this.rapidAssaultDeltaMovement == null && (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) && this.timer > 6 && !this.f_19861_ && this.m_5448_() != null && this.m_5448_().m_6084_()) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_20182_());
            float f = 0.0f;
            f = this.m_5448_() != null ? (float)Mth.m_14136_((double)(this.m_5448_().m_20189_() - this.m_20189_()), (double)(this.m_5448_().m_20185_() - this.m_20185_())) : (float)Math.toRadians(this.m_146908_() % 360.0f + 90.0f);
            this.rapidAssaultDeltaMovement = new Vec3(Math.cos(f) * 18.0, 0.0, Math.sin(f) * 18.0);
        }
    }

    @Override
    protected void registerAttackGoal() {
        super.registerAttackGoal();
        this.f_21345_.m_25352_(0, (Goal)new RapidAssaultGoal(this));
    }

    @Override
    public int m_6062_() {
        return 750;
    }

    @Override
    public float getStepHeight() {
        if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_ASSAULT)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            return 1.5f;
        }
        return super.getStepHeight();
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "move", 2.0f, this::moving));
        data.addAnimationController(new AnimationController((IAnimatable)this, "rot", 0.0f, this::rot));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        ShogunEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.parryTimes % 4 == 1 ? "parry" : (this.parryTimes % 4 == 2 ? "parry1" : (this.parryTimes % 4 == 3 ? "parry2" : "parry3")), Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_out_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_WITHDRAW_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("withdraw_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_JUMP_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 0 ? "attacks" : ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 1 ? "attacks2" : "attacks3"), Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("roll2", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dodge", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("roll", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("block", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_ASSAULT)).booleanValue()) {
            event.getController().setAnimationSpeed(3.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run_attack", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("destroy_projectile", Boolean.valueOf(true)));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState moving(AnimationEvent<P> event) {
        boolean shouldPlayWalkAnimation;
        event.getController().animationSpeed = 1.0;
        ShogunEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        boolean bl = shouldPlayWalkAnimation = (Boolean)this.f_19804_.m_135370_(IS_DODGE) == false && (Boolean)this.f_19804_.m_135370_(IS_DASH) == false && (Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL) == false;
        if (((Boolean)this.f_19804_.m_135370_(IS_JUMP_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump_end", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !shouldPlayWalkAnimation)) {
            event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15));
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "walk_pulled_out_weapon" : "walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("null", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState rot(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("null", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public boolean m_7490_() {
        return true;
    }

    static class RapidAssaultGoal
    extends Goal {
        protected final ShogunEntity mob;
        protected int cooldown;

        public RapidAssaultGoal(ShogunEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            if (!((Boolean)this.mob.f_19804_.m_135370_(NewSamuraiEntity.IS_PULLED_OUT_WEAPON)).booleanValue() && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() || this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && 0.35f <= this.mob.m_21223_() / this.mob.m_21233_()) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
                float f = 0.0f;
                f = this.mob.m_5448_() != null ? (float)Mth.m_14136_((double)(this.mob.m_5448_().m_20189_() - this.mob.m_20189_()), (double)(this.mob.m_5448_().m_20185_() - this.mob.m_20185_())) : (float)Math.toRadians(this.mob.m_146908_() % 360.0f + 90.0f);
                this.mob.rapidAssaultDeltaMovement = new Vec3(Math.cos(f) * 18.0, 0.0, Math.sin(f) * 18.0);
            }
            return this.mob.f_19797_ >= this.cooldown && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_142582_((Entity)this.mob.m_5448_()) && (this.mob.m_20270_((Entity)this.mob.m_5448_()) > 10.0f || (double)this.mob.m_20270_((Entity)this.mob.m_5448_()) > 5.5 && this.mob.m_217043_().m_188503_(30) == 0 || 0.35f <= this.mob.m_21223_() / this.mob.m_21233_());
        }

        public boolean m_8045_() {
            return this.mob.timer < 4 && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.f_19804_.m_135381_(IS_ASSAULT, (Object)true);
            this.mob.f_19804_.m_135381_(NewSamuraiEntity.IS_PULLED_OUT_WEAPON, (Object)true);
            this.mob.entityList = new ArrayList<Entity>();
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.f_19804_.m_135381_(IS_ASSAULT, (Object)false);
            this.cooldown = 130 + this.mob.m_217043_().m_188503_(20) + this.mob.f_19797_;
            if (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) {
                this.cooldown = 0;
            } else {
                this.mob.f_19804_.m_135381_(NewSamuraiEntity.CAN_MELEE, (Object)((double)this.mob.m_5448_().m_20270_((Entity)this.mob) <= 1.76 ? 1 : 0));
            }
            this.mob.f_19804_.m_135381_(NewSamuraiEntity.DODGE_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(NewSamuraiEntity.DASH_COOLDOWN, (Object)35);
            this.mob.entityList = new ArrayList<Entity>();
        }

        public void m_8037_() {
            float y;
            float f;
            Object e;
            float rot;
            super.m_8037_();
            if (this.mob.timer == 0) {
                rot = -79.0f;
                e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 4, rot, 1.1f, 2.3f);
                e.m_20219_(this.mob.m_5448_().m_20182_());
                ((AttackEffects)((Object)e)).setCaster((LivingEntity)this.mob);
                e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 6.335, this.mob.f_20883_));
                this.mob.f_19853_.m_7967_((Entity)e);
                this.mob.entityList.add((Entity)e);
            }
            if (this.mob.timer == 1) {
                rot = -79.0f;
                e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.3f);
                e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 6.335, this.mob.f_20883_));
                this.mob.f_19853_.m_7967_((Entity)e);
                this.mob.entityList.add((Entity)e);
                AttackEffects e1 = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, -195.0f, 1.1f, 2.3f);
                e1.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                e1.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 6.335, this.mob.f_20883_));
                this.mob.f_19853_.m_7967_((Entity)e1);
                this.mob.entityList.add(e1);
                f = 0.0f;
                y = 0.0f;
                float m = 18.0f;
                if (this.mob.m_5448_() != null) {
                    f = (float)Mth.m_14136_((double)(this.mob.m_5448_().m_20189_() - this.mob.m_20189_()), (double)(this.mob.m_5448_().m_20185_() - this.mob.m_20185_()));
                    y = (float)Math.min(Math.max(this.mob.m_5448_().m_20186_() - this.mob.m_20186_(), -18.0), 18.0);
                    if (y > 9.0f || y < -9.0f) {
                        m -= Math.abs(y - 9.0f);
                    }
                } else {
                    f = (float)Math.toRadians(this.mob.m_146908_() % 360.0f + 90.0f);
                }
                if (this.mob.rapidAssaultDeltaMovement != null) {
                    Vec3 vec3 = this.mob.rapidAssaultDeltaMovement.m_82549_(this.mob.m_20182_());
                    if (this.mob.m_5448_() != null && (this.mob.m_20238_(vec3) <= this.mob.m_5448_().m_20238_(vec3) || !(this.mob.m_5448_() instanceof Player))) {
                        this.mob.rapidAssaultDeltaMovement = new Vec3(Math.cos(f) * (double)m, (double)y, Math.sin(f) * (double)m);
                    }
                } else {
                    this.mob.rapidAssaultDeltaMovement = new Vec3(Math.cos(f) * 18.0, 0.0, Math.sin(f) * 18.0);
                }
                if (!this.mob.entityList.isEmpty()) {
                    for (Entity entity : this.mob.entityList) {
                        entity.m_7618_(EntityAnchorArgument.Anchor.EYES, entity.m_20182_().m_82549_(this.mob.rapidAssaultDeltaMovement));
                        entity.m_146922_(-(entity.m_146908_() % 360.0f) - 90.0f);
                    }
                }
                this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
                NewSamuraiEntity.DestroyProjectiles(this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f);
            }
            ++this.mob.timer;
            if (this.mob.m_5448_() != null && this.mob.timer < 3) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.timer == 3) {
                int l;
                this.mob.m_6478_(MoverType.SELF, this.mob.rapidAssaultDeltaMovement.m_82490_(1.1));
                Vec3 vec3 = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.135, this.mob.f_20883_);
                if (!this.mob.entityList.isEmpty()) {
                    for (Entity entity : this.mob.entityList) {
                        f = (float)Math.sqrt((this.mob.m_20185_() - entity.m_20185_()) * (this.mob.m_20185_() - entity.m_20185_()) + (this.mob.m_20189_() - entity.m_20189_()) * (this.mob.m_20189_() - entity.m_20189_()));
                        y = (float)(Math.atan2(this.mob.m_20185_() - entity.m_20185_(), this.mob.m_20189_() - entity.m_20189_()) * 57.29577951308232);
                        float x = (float)(Mth.m_14136_((double)(this.mob.m_20186_() - entity.m_20186_()), (double)f) * 57.29577951308232);
                        entity.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
                        entity.m_146922_(Mth.m_14177_((float)y) - 90.0f);
                        entity.m_146926_(Mth.m_14177_((float)(-x)));
                        entity.f_19859_ = entity.m_146908_();
                        entity.f_19860_ = entity.m_146909_();
                    }
                }
                ArrayList<LivingEntity> HitList = new ArrayList<LivingEntity>();
                ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                for (l = -1; l < 19; ++l) {
                    Vec3 pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, -1.25 - (double)(l + 1), this.mob.f_20883_);
                    AABB aabb = new AABB(pos.m_7096_() - 0.75, pos.m_7098_(), pos.m_7094_() - 0.75, pos.m_7096_() + 0.75, pos.m_7098_() + 0.85, pos.m_7094_() + 0.75);
                    aabb.m_82400_(0.35);
                    for (LivingEntity entityHit : this.mob.f_19853_.m_45976_(LivingEntity.class, aabb.m_82400_(0.65))) {
                        if (entityHit.m_7307_((Entity)this.mob) || HitList.contains(entityHit)) continue;
                        entityHit.f_19802_ = 0;
                        boolean b = false;
                        if (entityHit instanceof Player || entityHit.m_21233_() > 36.0f) {
                            Player player;
                            HitList.add(entityHit);
                            if (entityHit instanceof Player && (player = (Player)entityHit).m_21254_() || !entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.3334f)) {
                                Player player2;
                                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob).m_19380_(), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.3333334f * 0.35f);
                                if (entityHit instanceof Player && (player2 = (Player)entityHit).m_21254_()) {
                                    player2.m_36384_(true);
                                }
                                if (!list.contains(entityHit)) {
                                    list.add(entityHit);
                                    float attackKnockback = (float)this.mob.m_21133_(Attributes.f_22282_) + 4.75f;
                                    double ratioX = Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                                    double ratioZ = -Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                                    CombatEvent.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, 0.0);
                                    b = true;
                                }
                            }
                        } else {
                            float damages = (float)this.mob.m_21133_(Attributes.f_22281_) * 1.3334f * (float)((Integer)IllagerAdditionsConfig.shogunAttackDamageMultiplier.get()).intValue();
                            double d = ((double)damages - this.mob.m_21133_(Attributes.f_22281_)) * (double)entityHit.m_21233_() / Math.max(1889.875 - (double)((this.mob.hitMobMap.get(entityHit) != null ? this.mob.hitMobMap.get(entityHit) : 0) * 65), 25.0);
                            d = Math.max(d, Math.min((double)(this.mob.hitMobMap.get(entityHit) != null ? this.mob.hitMobMap.get(entityHit) : 0), 6.25) + (double)(this.mob.hitMobMap.get(entityHit) != null ? this.mob.hitMobMap.get(entityHit) : 0) * 0.0235);
                            damages = (float)((double)damages + d);
                            if (!entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), damages)) {
                                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob).m_19380_(), damages * 0.65f);
                            } else {
                                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), damages);
                            }
                            if (!list.contains(entityHit)) {
                                list.add(entityHit);
                                float attackKnockback = (float)this.mob.m_21133_(Attributes.f_22282_) + 4.75f;
                                double ratioX = Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                                double ratioZ = -Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
                                CombatEvent.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, 0.0);
                                b = true;
                            }
                        }
                        if (!b) {
                            entityHit.m_20256_(Vec3.f_82478_);
                        }
                        entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 6));
                        AttackEffects e2 = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, 10 + entityHit.m_217043_().m_188503_(26), 1.1f, 1.75f);
                        e2.m_20219_(CombatEvent.getOffsetPos((Entity)entityHit, 0.0, 0.65, 0.535 * (double)(entityHit.m_217043_().m_188499_() ? -1 : 1), entityHit.f_20883_));
                        e2.m_7618_(EntityAnchorArgument.Anchor.EYES, entityHit.m_20182_().m_82542_((double)entityHit.m_217043_().m_188503_(3) + 0.5, 1.0, (double)entityHit.m_217043_().m_188503_(3) + 0.5));
                        this.mob.f_19853_.m_7967_((Entity)e2);
                    }
                }
                for (l = -2; l < 18; ++l) {
                    Vec3 pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, this.mob.rapidAssaultDeltaMovement.m_7098_() / (double)l, -1.25 - (double)(l + 1), this.mob.f_20883_);
                    AABB aabb = new AABB(pos.m_7096_() - 2.75, pos.m_7098_(), pos.m_7094_() - 2.75, pos.m_7096_() + 2.75, pos.m_7098_() + 1.85, pos.m_7094_() + 2.75);
                    this.mob.reboundedProjectiles.addAll(this.mob.f_19853_.m_45976_(Projectile.class, aabb));
                }
                CombatEvent.AreaAttack((LivingEntity)this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 360.0f, 0.86667f, 0.0, 1.0, false);
                NewSamuraiEntity.DestroyProjectiles(this.mob, 5.0f, 5.0f, 5.0f, 5.0f, 360.0f);
                if (!this.mob.entityList.isEmpty()) {
                    for (Entity entity : this.mob.entityList) {
                        if (entity == this.mob) continue;
                        entity.m_20219_(vec3);
                    }
                }
                this.mob.rapidAssaultDeltaMovement = null;
                if (!this.mob.m_20096_() && this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_()) {
                    this.mob.m_20334_(0.0, 0.45, 0.0);
                }
            }
        }
    }
}

